/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.block;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.protectionlib.ProtectionLib;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockMechanicListener
implements Listener {
    private final MechanicFactory factory;

    public BlockMechanicListener(BlockMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMushroomPhysics(BlockPhysicsEvent event) {
        if (event.getChangedType() == Material.MUSHROOM_STEM) {
            event.setCancelled(true);
            event.getBlock().getState().update(true, false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakingCustomBlock(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.MUSHROOM_STEM || !event.isDropItems()) {
            return;
        }
        BlockMechanic blockMechanic = OraxenBlocks.getBlockMechanic(block);
        if (blockMechanic == null) {
            return;
        }
        blockMechanic.getDrop().spawns(block.getLocation(), event.getPlayer().getInventory().getItemInMainHand());
        event.setDropItems(false);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlacingMushroomBlock(BlockPlaceEvent event) {
        if (event.getBlockPlaced().getType() != Material.MUSHROOM_STEM || OraxenItems.exists(OraxenItems.getIdByItem(event.getItemInHand()))) {
            return;
        }
        Block block = event.getBlock();
        MultipleFacing blockData = (MultipleFacing)block.getBlockData();
        BlockMechanic.setBlockFacing(blockData, 15);
        block.setBlockData((BlockData)blockData, false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLimitedPlacing(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace blockFace = event.getBlockFace();
        ItemStack item = event.getItem();
        if (item == null || block == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || block.getType() != Material.NOTE_BLOCK) {
            return;
        }
        BlockMechanic mechanic = (BlockMechanic)this.factory.getMechanic(OraxenItems.getIdByItem(item));
        if (mechanic == null || !mechanic.hasLimitedPlacing()) {
            return;
        }
        if (block.getType().isInteractable() && block.getType() != Material.NOTE_BLOCK) {
            return;
        }
        LimitedPlacing limitedPlacing = mechanic.getLimitedPlacing();
        Block belowPlaced = block.getRelative(blockFace).getRelative(BlockFace.DOWN);
        if (limitedPlacing.isNotPlacableOn(block, blockFace)) {
            event.setCancelled(true);
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.ALLOW) {
            if (!limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.DENY && limitedPlacing.checkLimitedMechanic(belowPlaced)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPrePlacingCustomBlock(PlayerInteractEvent event) {
        Block target;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() == null || event.getHand() == null) {
            return;
        }
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        Block placedAgainst = event.getClickedBlock();
        if (this.factory.isNotImplementedIn(itemID) || placedAgainst == null) {
            return;
        }
        Player player = event.getPlayer();
        Material type = placedAgainst.getType();
        if (BlockHelpers.isReplaceable(type)) {
            target = placedAgainst;
        } else {
            target = placedAgainst.getRelative(event.getBlockFace());
            if (target.getType() != Material.AIR && target.getType() != Material.WATER && target.getType() != Material.CAVE_AIR) {
                return;
            }
        }
        if (BlockHelpers.isStandingInside(player, target) || !ProtectionLib.canBuild((Player)player, (Location)target.getLocation())) {
            return;
        }
        BlockData curentBlockData = target.getBlockData();
        BlockState currentBlockState = target.getState();
        MultipleFacing newBlockData = (MultipleFacing)Bukkit.createBlockData((Material)Material.MUSHROOM_STEM);
        BlockMechanic mechanic = (BlockMechanic)this.factory.getMechanic(itemID);
        int customVariation = mechanic.getCustomVariation();
        BlockMechanic.setBlockFacing(newBlockData, customVariation);
        Utils.swingHand(player, event.getHand());
        target.setBlockData((BlockData)newBlockData);
        BlockPlaceEvent blockPlaceEvent = new BlockPlaceEvent(target, currentBlockState, placedAgainst, item, player, true, event.getHand());
        if (player.getGameMode() == GameMode.ADVENTURE) {
            blockPlaceEvent.setCancelled(true);
        }
        if (!blockPlaceEvent.callEvent() || !blockPlaceEvent.canBuild()) {
            target.setBlockData(curentBlockData, false);
            return;
        }
        event.setCancelled(true);
        if (player.getGameMode() != GameMode.CREATIVE) {
            item.setAmount(item.getAmount() - 1);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSetFire(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (block == null || block.getType() != Material.MUSHROOM_STEM) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getBlockFace() != BlockFace.UP) {
            return;
        }
        if (item == null) {
            return;
        }
        BlockMechanic mechanic = OraxenBlocks.getBlockMechanic(block);
        if (mechanic == null || !mechanic.canIgnite()) {
            return;
        }
        if (item.getType() != Material.FLINT_AND_STEEL && item.getType() != Material.FIRE_CHARGE) {
            return;
        }
        new BlockIgniteEvent(block, BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL, (Entity)event.getPlayer()).callEvent();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCatchFire(BlockIgniteEvent event) {
        Block block = event.getBlock();
        BlockMechanic mechanic = OraxenBlocks.getBlockMechanic(block);
        if (block.getType() != Material.MUSHROOM_STEM || mechanic == null) {
            return;
        }
        if (!mechanic.canIgnite()) {
            event.setCancelled(true);
        }
        block.getWorld().playSound(block.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        block.getRelative(BlockFace.UP).setType(Material.FIRE);
    }
}

