/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockSoundListener;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.configuration.ConfigurationSection;

public class BlockMechanicFactory
extends MechanicFactory {
    private static final List<JsonObject> MUSHROOM_STEM_BLOCKSTATE_OVERRIDES = new ArrayList<JsonObject>();
    private static final Map<Integer, BlockMechanic> BLOCK_PER_VARIATION = new HashMap<Integer, BlockMechanic>();
    public final List<String> toolTypes;
    public final boolean customSounds;

    public BlockMechanicFactory(ConfigurationSection section) {
        super(section);
        this.toolTypes = section.getStringList("tool_types");
        this.customSounds = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds").getBoolean("noteblock_and_block", true);
        OraxenPlugin.get().getResourcePack().addModifiers(this.getMechanicID(), packFolder -> {
            OraxenPlugin.get().getResourcePack();
            ResourcePack.writeStringToVirtual("assets/minecraft/blockstates", "mushroom_stem.json", this.getBlockstateContent());
        });
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new BlockMechanicListener(this));
        if (this.customSounds) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new BlockSoundListener());
        }
    }

    private String getBlockstateContent() {
        JsonObject mushroomStem = new JsonObject();
        JsonArray multipart = new JsonArray();
        multipart.add((JsonElement)BlockMechanicFactory.getBlockstateOverride("block/mushroom_stem", 15));
        for (JsonObject override : MUSHROOM_STEM_BLOCKSTATE_OVERRIDES) {
            multipart.add((JsonElement)override);
        }
        mushroomStem.add("multipart", (JsonElement)multipart);
        return mushroomStem.toString();
    }

    public static JsonObject getBlockstateOverride(String modelName, int when) {
        JsonObject content = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("model", modelName);
        content.add("apply", (JsonElement)model);
        content.add("when", (JsonElement)BlockMechanic.getBlockstateWhenFields(when));
        return content;
    }

    @Override
    public Mechanic parse(ConfigurationSection itemMechanicConfiguration) {
        BlockMechanic mechanic = new BlockMechanic(this, itemMechanicConfiguration);
        MUSHROOM_STEM_BLOCKSTATE_OVERRIDES.add(BlockMechanicFactory.getBlockstateOverride(mechanic.getModel(itemMechanicConfiguration.getParent().getParent()), mechanic.getCustomVariation()));
        BLOCK_PER_VARIATION.put(mechanic.getCustomVariation(), mechanic);
        this.addToImplemented(mechanic);
        return mechanic;
    }

    public static BlockMechanic getBlockMechanic(int customVariation) {
        return BLOCK_PER_VARIATION.get(customVariation);
    }

    public static BlockMechanic getBlockMechanic(Block block) {
        return block.getType() == Material.MUSHROOM_STEM ? BLOCK_PER_VARIATION.get(BlockMechanic.getCode(block)) : null;
    }

    public static void setBlockModel(Block block, String itemId) {
        MechanicFactory mechanicFactory = MechanicsManager.getMechanicFactory("block");
        BlockMechanic blockMechanic = (BlockMechanic)mechanicFactory.getMechanic(itemId);
        MultipleFacing newBlockData = (MultipleFacing)Bukkit.createBlockData((Material)Material.MUSHROOM_STEM);
        BlockMechanic.setBlockFacing(newBlockData, blockMechanic.getCustomVariation());
        block.setBlockData((BlockData)newBlockData, false);
    }

    public static boolean setBlockModel(Block block, String itemId, String blockDataMaterial) {
        if (block == null || itemId == null || itemId.isEmpty()) {
            return false;
        }
        MechanicFactory mechanicFactory = MechanicsManager.getMechanicFactory("block");
        BlockMechanic blockMechanic = (BlockMechanic)mechanicFactory.getMechanic(itemId);
        Material material = blockDataMaterial == null || blockDataMaterial.isEmpty() ? Material.MUSHROOM_STEM : Material.getMaterial((String)blockDataMaterial.toUpperCase().replace(" ", "_").replace("-", "_"));
        MultipleFacing newBlockData = (MultipleFacing)Bukkit.createBlockData((Material)material);
        BlockMechanic.setBlockFacing(newBlockData, blockMechanic.getCustomVariation());
        block.setBlockData((BlockData)newBlockData, false);
        return true;
    }
}

