/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import com.jeff_media.morepersistentdatatypes.DataType;
import com.jeff_media.persistentdataserializer.PersistentDataSerializer;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataContainer;

public class ItemUpdater
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Settings.UPDATE_ITEMS.toBool().booleanValue()) {
            return;
        }
        PlayerInventory inventory = event.getPlayer().getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack oldItem = inventory.getItem(i);
            ItemStack newItem = ItemUpdater.updateItem(oldItem);
            if (oldItem == null || oldItem.equals((Object)newItem)) continue;
            inventory.setItem(i, newItem);
        }
    }

    @EventHandler
    public void onPlayerPickUp(EntityPickupItemEvent event) {
        ItemStack newItem;
        if (!Settings.UPDATE_ITEMS.toBool().booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        ItemStack oldItem = event.getItem().getItemStack();
        if (oldItem.equals((Object)(newItem = ItemUpdater.updateItem(oldItem)))) {
            return;
        }
        event.getItem().setItemStack(newItem);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemEnchant(PrepareItemEnchantEvent event) {
        String id = OraxenItems.getIdByItem(event.getItem());
        ItemBuilder builder = OraxenItems.getItemById(id);
        if (builder == null || !builder.hasOraxenMeta()) {
            return;
        }
        if (builder.getOraxenMeta().isDisableEnchanting()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemEnchant(PrepareAnvilEvent event) {
        ItemStack item = event.getInventory().getItem(0);
        ItemStack result = event.getResult();
        String id = OraxenItems.getIdByItem(item);
        ItemBuilder builder = OraxenItems.getItemById(id);
        if (builder == null || !builder.hasOraxenMeta()) {
            return;
        }
        if (builder.getOraxenMeta().isDisableEnchanting()) {
            if (result == null || item == null) {
                return;
            }
            if (!result.getEnchantments().equals(item.getEnchantments())) {
                event.setResult(null);
            }
        }
    }

    public static ItemStack updateItem(ItemStack oldItem) {
        String id = OraxenItems.getIdByItem(oldItem);
        if (id == null) {
            return oldItem;
        }
        NamespacedKey guiItemKey = Objects.requireNonNull(NamespacedKey.fromString((String)"oraxen:if-uuid"));
        Utils.editItemMeta(oldItem, itemMeta -> itemMeta.getPersistentDataContainer().remove(guiItemKey));
        Optional<ItemBuilder> newItemBuilder = OraxenItems.getOptionalItemById(id);
        if (newItemBuilder.isEmpty() || newItemBuilder.get().getOraxenMeta().isNoUpdate()) {
            return oldItem;
        }
        ItemStack newItem = NMSHandlers.getHandler().copyItemNBTTags(oldItem, newItemBuilder.get().build());
        newItem.setAmount(oldItem.getAmount());
        Utils.editItemMeta(newItem, itemMeta -> {
            ItemMeta oldMeta = oldItem.getItemMeta();
            ItemMeta newMeta = newItem.getItemMeta();
            if (oldMeta == null || newMeta == null) {
                return;
            }
            PersistentDataContainer oldPdc = oldMeta.getPersistentDataContainer();
            PersistentDataContainer itemPdc = itemMeta.getPersistentDataContainer();
            PersistentDataSerializer.fromMapList((List)PersistentDataSerializer.toMapList((PersistentDataContainer)oldPdc), (PersistentDataContainer)itemPdc);
            for (Map.Entry entry : oldMeta.getEnchants().entrySet()) {
                itemMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            for (Map.Entry entry : newMeta.getEnchants().entrySet().stream().filter(e -> !oldMeta.getEnchants().containsKey(e.getKey())).toList()) {
                itemMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            int cmd = newMeta.hasCustomModelData() ? newMeta.getCustomModelData() : (oldMeta.hasCustomModelData() ? oldMeta.getCustomModelData() : 0);
            itemMeta.setCustomModelData(Integer.valueOf(cmd));
            if (Settings.OVERRIDE_ITEM_LORE.toBool().booleanValue()) {
                itemMeta.setLore(newMeta.getLore());
            } else {
                itemMeta.setLore(oldMeta.getLore());
            }
            if (newMeta.hasAttributeModifiers()) {
                itemMeta.setAttributeModifiers(newMeta.getAttributeModifiers());
            } else {
                itemMeta.setAttributeModifiers(oldMeta.getAttributeModifiers());
            }
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                if (oldMeta instanceof Damageable) {
                    Damageable oldDmg = (Damageable)oldMeta;
                    damageable.setDamage(oldDmg.getDamage());
                }
            }
            if (oldMeta.isUnbreakable()) {
                itemMeta.setUnbreakable(true);
            }
            if (itemMeta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
                if (oldMeta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta oldLeatherMeta = (LeatherArmorMeta)oldMeta;
                    if (newMeta instanceof LeatherArmorMeta) {
                        LeatherArmorMeta newLeatherMeta = (LeatherArmorMeta)newMeta;
                        if (oldItem.getType() == Material.LEATHER_HORSE_ARMOR) {
                            leatherArmorMeta.setColor(oldLeatherMeta.getColor());
                        } else {
                            leatherArmorMeta.setColor(newLeatherMeta.getColor());
                            ((ItemBuilder)newItemBuilder.get()).save();
                        }
                    }
                }
            }
            if (itemMeta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                if (oldMeta instanceof PotionMeta) {
                    PotionMeta oldPotionMeta = (PotionMeta)oldMeta;
                    potionMeta.setColor(oldPotionMeta.getColor());
                }
            }
            if (itemMeta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)itemMeta;
                if (oldMeta instanceof MapMeta) {
                    MapMeta oldMapMeta = (MapMeta)oldMeta;
                    mapMeta.setColor(oldMapMeta.getColor());
                }
            }
            String string = AdventureUtils.parseLegacy(oldMeta.getDisplayName());
            String originalName = AdventureUtils.parseLegacy((String)oldPdc.getOrDefault(ItemBuilder.ORIGINAL_NAME_KEY, DataType.STRING, (Object)""));
            if (Settings.OVERRIDE_RENAMED_ITEMS.toBool().booleanValue()) {
                itemMeta.setDisplayName(newMeta.getDisplayName());
            } else if (!originalName.equals(string)) {
                itemMeta.setDisplayName(oldMeta.getDisplayName());
            } else {
                itemMeta.setDisplayName(newMeta.getDisplayName());
            }
            itemPdc.set(ItemBuilder.ORIGINAL_NAME_KEY, DataType.STRING, (Object)newMeta.getDisplayName());
        });
        return newItem;
    }
}

