/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.font;

import com.comphenix.protocol.events.PacketListener;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.ConfigsManager;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.Font;
import io.th0rgal.oraxen.font.FontEvents;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.font.packets.InventoryPacketListener;
import io.th0rgal.oraxen.font.packets.TitlePacketListener;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontManager {
    public final boolean autoGenerate;
    public final String permsChatcolor;
    public static Map<String, GlyphBitMap> glyphBitMaps = new HashMap<String, GlyphBitMap>();
    private final Map<String, Glyph> glyphMap;
    private final Map<String, Glyph> glyphByPlaceholder;
    private final Map<Character, String> reverse;
    private final FontEvents fontEvents;
    private final Set<Font> fonts;
    private final boolean useNmsGlyphs;
    private final Map<UUID, List<String>> currentGlyphCompletions = new HashMap<UUID, List<String>>();

    public FontManager(ConfigsManager configsManager) {
        YamlConfiguration fontConfiguration = configsManager.getFont();
        ConfigurationSection bitmapSection = fontConfiguration.getConfigurationSection("bitmaps");
        this.autoGenerate = fontConfiguration.getBoolean("settings.automatically_generate");
        this.permsChatcolor = fontConfiguration.getString("settings.perms_chatcolor");
        if (bitmapSection != null) {
            glyphBitMaps = bitmapSection.getKeys(false).stream().collect(HashMap::new, (map, key) -> {
                ConfigurationSection section = bitmapSection.getConfigurationSection(key);
                if (section != null) {
                    map.put(key, new GlyphBitMap(section.getString("texture"), section.getInt("rows"), section.getInt("columns"), section.getInt("ascent", 8), section.getInt("height", 8)));
                }
            }, HashMap::putAll);
        }
        this.glyphMap = new HashMap<String, Glyph>();
        this.glyphByPlaceholder = new HashMap<String, Glyph>();
        this.reverse = new HashMap<Character, String>();
        this.fontEvents = new FontEvents(this);
        this.fonts = new HashSet<Font>();
        this.loadGlyphs(configsManager.parseGlyphConfigs());
        if (fontConfiguration.isConfigurationSection("fonts")) {
            this.loadFonts(fontConfiguration.getConfigurationSection("fonts"));
        }
        if (Settings.NMS_GLYPHS.toBool().booleanValue() && NMSHandlers.getHandler() != null) {
            if (VersionUtil.isSupportedVersionOrNewer("1.20.2")) {
                this.useNmsGlyphs = false;
                Logs.logWarning("NMS Glyphs are not supported on 1.20.2 and newer at the moment...");
            } else {
                this.useNmsGlyphs = true;
                NMSHandlers.getHandler().setupNmsGlyphs();
                Logs.logSuccess("Oraxens NMS Glyph system has been enabled!");
                Logs.logInfo("Disabling packet-based glyph systems", true);
                OraxenPlugin.get().getProtocolManager().removePacketListener((PacketListener)new InventoryPacketListener());
                OraxenPlugin.get().getProtocolManager().removePacketListener((PacketListener)new TitlePacketListener());
            }
        } else {
            this.useNmsGlyphs = false;
        }
    }

    public boolean useNmsGlyphs() {
        return this.useNmsGlyphs;
    }

    public static GlyphBitMap getGlyphBitMap(String id) {
        return id != null ? (GlyphBitMap)glyphBitMaps.getOrDefault(id, null) : null;
    }

    public void verifyRequired() {
        OraxenPlugin.get().saveResource("glyphs/required.yml", true);
    }

    public void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)this.fontEvents, (Plugin)OraxenPlugin.get());
    }

    public void unregisterEvents() {
        HandlerList.unregisterAll((Listener)this.fontEvents);
    }

    private void loadGlyphs(Collection<Glyph> glyphs) {
        this.verifyRequiredGlyphs();
        for (Glyph glyph : glyphs) {
            if (glyph.getCharacter().isBlank()) continue;
            this.glyphMap.put(glyph.getName(), glyph);
            this.reverse.put(Character.valueOf(glyph.getCharacter().charAt(0)), glyph.getName());
            for (String placeholder : glyph.getPlaceholders()) {
                this.glyphByPlaceholder.put(placeholder, glyph);
            }
        }
    }

    private void loadFonts(ConfigurationSection section) {
        for (String fontName : section.getKeys(false)) {
            ConfigurationSection fontSection = section.getConfigurationSection(fontName);
            this.fonts.add(new Font(fontSection.getString("type"), fontSection.getString("file"), Float.valueOf((float)fontSection.getDouble("shift_x")), Float.valueOf((float)fontSection.getDouble("shift_y")), Float.valueOf((float)fontSection.getDouble("size")), Float.valueOf((float)fontSection.getDouble("oversample"))));
        }
    }

    private void verifyRequiredGlyphs() {
        this.checkYamlKeys(new File(OraxenPlugin.get().getDataFolder() + "/glyphs/shifts.yml"));
        this.checkYamlKeys(new File(OraxenPlugin.get().getDataFolder() + "/glyphs/required.yml"));
    }

    private void checkYamlKeys(File file) {
        File tempFile = new File(OraxenPlugin.get().getDataFolder() + "/glyphs/temp.yml");
        try {
            Files.copy(Objects.requireNonNull(OraxenPlugin.get().getResource("glyphs/" + file.getName())), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!file.exists()) {
                OraxenPlugin.get().saveResource("glyphs/" + file.getName(), false);
            } else if (!Settings.DISABLE_AUTOMATIC_GLYPH_CODE.toBool().booleanValue()) {
                List tempKeys = OraxenYaml.loadConfiguration(tempFile).getKeys(false).stream().toList();
                List requiredKeys = OraxenYaml.loadConfiguration(file).getKeys(false).stream().toList();
                if (!new HashSet(requiredKeys).containsAll(tempKeys)) {
                    file.renameTo(new File(OraxenPlugin.get().getDataFolder() + "/glyphs/" + file.getName() + ".old"));
                    OraxenPlugin.get().saveResource("glyphs/" + file.getName(), true);
                    Logs.logWarning("glyphs/" + file.getName() + " was incorrect, renamed to .old and regenerated the default one");
                }
            }
        }
        catch (IOException e) {
            file.renameTo(new File(OraxenPlugin.get().getDataFolder() + "/glyphs/" + file.getName() + ".old"));
            OraxenPlugin.get().saveResource("glyphs/" + file.getName(), true);
        }
        tempFile.delete();
    }

    public final Collection<Glyph> getGlyphs() {
        return this.glyphMap.values();
    }

    public final Collection<Glyph> getEmojis() {
        return this.glyphMap.values().stream().filter(Glyph::isEmoji).toList();
    }

    public final Collection<Font> getFonts() {
        return this.fonts;
    }

    public Font getFontFromFile(String file) {
        return this.getFonts().stream().filter(font -> font.file().equals(file)).findFirst().orElse(null);
    }

    @NotNull
    public Glyph getGlyphFromName(String id) {
        return this.glyphMap.get(id) != null ? this.glyphMap.get(id) : this.glyphMap.get("required");
    }

    @Nullable
    public Glyph getGlyphFromID(String id) {
        return this.glyphMap.get(id);
    }

    public Glyph getGlyphFromPlaceholder(String word) {
        return this.glyphByPlaceholder.get(word);
    }

    public Map<String, Glyph> getGlyphByPlaceholderMap() {
        return this.glyphByPlaceholder;
    }

    public Map<Character, String> getReverseMap() {
        return this.reverse;
    }

    public String getShift(int length) {
        StringBuilder output = new StringBuilder();
        String prefix = "shift_";
        if (length < 0) {
            prefix = "neg_shift_";
            length = -length;
        }
        while (length > 0) {
            int biggestPower = Integer.highestOneBit(length);
            output.append(this.getGlyphFromName(prefix + biggestPower).getCharacter());
            length -= biggestPower;
        }
        return output.toString();
    }

    public void sendGlyphTabCompletion(Player player) {
        List completions = this.getGlyphByPlaceholderMap().values().stream().filter(Glyph::hasTabCompletion).flatMap(glyph -> Settings.UNICODE_COMPLETIONS.toBool() != false ? Stream.of(glyph.getCharacter()) : Arrays.stream(glyph.getPlaceholders())).toList();
        if (VersionUtil.isSupportedVersionOrNewer("1.19.4")) {
            player.removeCustomChatCompletions((Collection)this.currentGlyphCompletions.getOrDefault(player.getUniqueId(), new ArrayList()));
            player.addCustomChatCompletions(completions);
            this.currentGlyphCompletions.put(player.getUniqueId(), completions);
        }
    }

    public void clearGlyphTabCompletions(Player player) {
        this.currentGlyphCompletions.remove(player.getUniqueId());
    }

    public record GlyphBitMap(String texture, int rows, int columns, int ascent, int height) {
        public JsonObject toJson(FontManager fontManager) {
            JsonObject json = new JsonObject();
            JsonArray chars = new JsonArray();
            List<Glyph> bitmapGlyphs = fontManager.getGlyphs().stream().filter(Glyph::hasBitmap).filter(g -> g.getBitMap() != null && g.getBitMap().equals(this)).toList();
            for (int i = 1; i <= this.rows(); ++i) {
                int currentRow = i;
                List<Glyph> glyphsInRow = bitmapGlyphs.stream().filter(g -> g.getBitmapEntry().row() == currentRow).toList();
                StringBuilder charRow = new StringBuilder();
                for (int j = 1; j <= this.columns(); ++j) {
                    int currentColumn = j;
                    Glyph glyph = glyphsInRow.stream().filter(g -> g.getBitmapEntry().column() == currentColumn).findFirst().orElse(null);
                    charRow.append(glyph != null ? glyph.getCharacter() : Glyph.WHITESPACE_GLYPH);
                }
                chars.add("");
                chars.set(i - 1, (JsonElement)new JsonPrimitive(charRow.toString()));
            }
            json.add("chars", (JsonElement)chars);
            json.addProperty("type", "bitmap");
            json.addProperty("ascent", (Number)this.ascent);
            json.addProperty("height", (Number)this.height);
            json.addProperty("file", (String)(this.texture.endsWith(".png") ? this.texture : this.texture + ".png"));
            return json;
        }
    }
}

