/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.ResourcesManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PackCommand {
    CommandAPICommand getPackCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("pack").withPermission("oraxen.command.pack")).withSubcommand((AbstractCommandAPICommand)this.sendPackCommand())).withSubcommand((AbstractCommandAPICommand)this.sendPackMessage())).withSubcommand((AbstractCommandAPICommand)this.extractDefaultPackContent());
    }

    private CommandAPICommand sendPackCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("send").withPermission("oraxen.command.pack.send")).withOptionalArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("targets")})).executes((sender, args) -> {
            Collection targets = (Collection)args.getOptional("targets").orElse(sender instanceof Player ? sender : null);
            if (targets != null) {
                for (Player target : targets) {
                    OraxenPlugin.get().getUploadManager().getSender().sendPack(target);
                }
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand sendPackMessage() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("msg").withOptionalArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("targets")})).executes((sender, args) -> {
            Collection targets = (Collection)args.getOptional("targets").orElse(sender instanceof Player ? sender : null);
            if (targets != null) {
                for (Player target : targets) {
                    Message.COMMAND_JOIN_MESSAGE.send((CommandSender)target, AdventureUtils.tagResolver("pack_url", OraxenPlugin.get().getUploadManager().getHostingProvider().getPackURL()));
                }
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand extractDefaultPackContent() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("extract_default").withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("folder").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"all", "textures", "models", "sounds"}))})).withOptionalArguments((AbstractArgument[])new Argument[]{new BooleanArgument("override")})).executes((sender, args) -> {
            String type = args.getOptional("folder").orElse("all");
            ZipInputStream zip = ResourcesManager.browse();
            try {
                ZipEntry entry = zip.getNextEntry();
                ResourcesManager resourcesManager = new ResourcesManager(OraxenPlugin.get());
                while (entry != null) {
                    this.extract(entry, type, resourcesManager, args.getOptional("override").orElse(false));
                    entry = zip.getNextEntry();
                }
                zip.closeEntry();
                zip.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }, new ExecutorType[0]);
    }

    private void extract(ZipEntry entry, String type, ResourcesManager resourcesManager, boolean override) {
        if (!entry.getName().startsWith("pack/" + (type.equals("all") ? "" : type))) {
            return;
        }
        resourcesManager.extractFileIfTrue(entry, !OraxenPlugin.get().getDataFolder().toPath().resolve(entry.getName()).toFile().exists() || override);
    }
}

