/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.api;

import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockBreakEvent;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockBreakEvent;
import io.th0rgal.oraxen.compatibilities.provided.lightapi.WrappedLightAPI;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class OraxenBlocks {
    public static Set<String> getBlockIDs() {
        return Arrays.stream(OraxenItems.getItemNames()).filter(OraxenBlocks::isOraxenBlock).collect(Collectors.toSet());
    }

    public static Set<String> getNoteBlockIDs() {
        return Arrays.stream(OraxenItems.getItemNames()).filter(OraxenBlocks::isOraxenNoteBlock).collect(Collectors.toSet());
    }

    public static Set<String> getStringBlockIDs() {
        return Arrays.stream(OraxenItems.getItemNames()).filter(OraxenBlocks::isOraxenStringBlock).collect(Collectors.toSet());
    }

    public static boolean isOraxenBlock(Block block) {
        if (block == null) {
            return false;
        }
        return switch (block.getType()) {
            case Material.NOTE_BLOCK -> {
                if (OraxenBlocks.getNoteBlockMechanic(block) != null) {
                    yield true;
                }
                yield false;
            }
            case Material.TRIPWIRE -> {
                if (OraxenBlocks.getStringMechanic(block) != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isOraxenBlock(String itemId) {
        return OraxenItems.hasMechanic(itemId, "noteblock") || OraxenItems.hasMechanic(itemId, "stringblock");
    }

    public static boolean isOraxenNoteBlock(Block block) {
        return block.getType() == Material.NOTE_BLOCK && OraxenBlocks.getNoteBlockMechanic(block) != null;
    }

    public static boolean isOraxenNoteBlock(String itemID) {
        return !NoteBlockMechanicFactory.getInstance().isNotImplementedIn(itemID);
    }

    public static boolean isOraxenStringBlock(Block block) {
        return block.getType() == Material.TRIPWIRE && OraxenBlocks.getStringMechanic(block) != null;
    }

    public static boolean isOraxenStringBlock(String itemID) {
        return StringBlockMechanicFactory.isEnabled() && !StringBlockMechanicFactory.getInstance().isNotImplementedIn(itemID);
    }

    public static void place(String itemID, Location location) {
        if (OraxenBlocks.isOraxenNoteBlock(itemID)) {
            OraxenBlocks.placeNoteBlock(location, itemID);
        } else if (OraxenBlocks.isOraxenStringBlock(itemID)) {
            OraxenBlocks.placeStringBlock(location, itemID);
        }
    }

    @Nullable
    public static BlockData getOraxenBlockData(String itemID) {
        if (OraxenBlocks.isOraxenNoteBlock(itemID)) {
            return NoteBlockMechanicFactory.getInstance().createNoteBlockData(itemID);
        }
        if (OraxenBlocks.isOraxenStringBlock(itemID)) {
            return StringBlockMechanicFactory.getInstance().createTripwireData(itemID);
        }
        return null;
    }

    private static void placeNoteBlock(Location location, String itemID) {
        NoteBlockMechanicFactory.setBlockModel(location.getBlock(), itemID);
        Block block = location.getBlock();
        PersistentDataContainer pdc = BlockHelpers.getPDC(block);
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (mechanic.hasLight()) {
            WrappedLightAPI.createBlockLight(block.getLocation(), mechanic.getLight());
        }
        if (mechanic.hasDryout() && mechanic.getDryout().isFarmBlock()) {
            pdc.set(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.STRING, (Object)mechanic.getItemID());
        }
        if (mechanic.isStorage() && mechanic.getStorage().getStorageType() == StorageMechanic.StorageType.STORAGE) {
            pdc.set(StorageMechanic.STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]);
        }
        OraxenBlocks.checkNoteBlockAbove(location);
    }

    private static void checkNoteBlockAbove(Location loc) {
        Block nextBlock;
        Block block = loc.getBlock().getRelative(BlockFace.UP);
        if (block.getType() == Material.NOTE_BLOCK) {
            block.getState().update(true, true);
        }
        if ((nextBlock = loc.getBlock().getRelative(BlockFace.UP, 2)).getType() == Material.NOTE_BLOCK) {
            OraxenBlocks.checkNoteBlockAbove(block.getLocation());
        }
    }

    private static void placeStringBlock(Location location, String itemID) {
        SaplingMechanic sapling;
        Block block = location.getBlock();
        Block blockAbove = block.getRelative(BlockFace.UP);
        StringBlockMechanicFactory.setBlockModel(block, itemID);
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(location.getBlock());
        if (mechanic == null) {
            return;
        }
        if (mechanic.isTall()) {
            if (!BlockHelpers.REPLACEABLE_BLOCKS.contains(blockAbove.getType())) {
                return;
            }
            blockAbove.setType(Material.TRIPWIRE);
        }
        if (mechanic.getLight() != -1) {
            WrappedLightAPI.createBlockLight(block.getLocation(), mechanic.getLight());
        }
        if (mechanic.isSapling() && (sapling = mechanic.getSaplingMechanic()) != null && sapling.canGrowNaturally()) {
            BlockHelpers.getPDC(block).set(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER, (Object)sapling.getNaturalGrowthTime());
        }
    }

    public static boolean remove(Location location, @Nullable Player player) {
        Block block = location.getBlock();
        if (OraxenBlocks.isOraxenNoteBlock(block)) {
            OraxenBlocks.removeNoteBlock(block, player);
        } else if (OraxenBlocks.isOraxenStringBlock(block)) {
            OraxenBlocks.removeStringBlock(block, player);
        } else {
            return false;
        }
        return true;
    }

    private static void removeNoteBlock(Block block, @Nullable Player player) {
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
            mechanic = mechanic.getDirectional().getParentMechanic();
        }
        if (player != null) {
            OraxenNoteBlockBreakEvent noteBlockBreakEvent = new OraxenNoteBlockBreakEvent(mechanic, block, player);
            OraxenPlugin.get().getServer().getPluginManager().callEvent((Event)noteBlockBreakEvent);
            if (noteBlockBreakEvent.isCancelled()) {
                return;
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                noteBlockBreakEvent.getDrop().spawns(block.getLocation(), player.getInventory().getItemInMainHand());
            }
        }
        if (mechanic.hasLight()) {
            WrappedLightAPI.removeBlockLight(block.getLocation());
        }
        if (mechanic.isStorage() && mechanic.getStorage().getStorageType() == StorageMechanic.StorageType.STORAGE) {
            mechanic.getStorage().dropStorageContent(block);
        }
        block.setType(Material.AIR);
        OraxenBlocks.checkNoteBlockAbove(block.getLocation());
    }

    private static void removeStringBlock(Block block, @Nullable Player player) {
        ItemStack item;
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
        ItemStack itemStack = item = player != null ? player.getInventory().getItemInMainHand() : new ItemStack(Material.AIR);
        if (mechanic == null) {
            return;
        }
        if (player != null) {
            OraxenStringBlockBreakEvent wireBlockBreakEvent = new OraxenStringBlockBreakEvent(mechanic, block, player);
            OraxenPlugin.get().getServer().getPluginManager().callEvent((Event)wireBlockBreakEvent);
            if (wireBlockBreakEvent.isCancelled()) {
                return;
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                wireBlockBreakEvent.getDrop().spawns(block.getLocation(), item);
            }
        }
        if (mechanic.hasLight()) {
            WrappedLightAPI.removeBlockLight(block.getLocation());
        }
        if (mechanic.isTall()) {
            block.getRelative(BlockFace.UP).setType(Material.AIR, false);
        }
        block.setType(Material.AIR, false);
        Block blockAbove = block.getRelative(BlockFace.UP);
        Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> {
            StringBlockMechanicListener.fixClientsideUpdate(block.getLocation());
            if (blockAbove.getType() == Material.TRIPWIRE) {
                OraxenBlocks.removeStringBlock(blockAbove, player);
            }
        }, 1L);
    }

    public static Mechanic getOraxenBlock(Location location) {
        Mechanic mechanic;
        if (!OraxenBlocks.isOraxenBlock(location.getBlock())) {
            mechanic = null;
        } else {
            switch (location.getBlock().getType()) {
                case NOTE_BLOCK: {
                    mechanic = OraxenBlocks.getNoteBlockMechanic(location.getBlock());
                    break;
                }
                case TRIPWIRE: {
                    mechanic = OraxenBlocks.getStringMechanic(location.getBlock());
                    break;
                }
                case MUSHROOM_STEM: {
                    mechanic = OraxenBlocks.getBlockMechanic(location.getBlock());
                    break;
                }
                default: {
                    mechanic = null;
                }
            }
        }
        return mechanic;
    }

    public static Mechanic getOraxenBlock(BlockData blockData) {
        return switch (blockData.getMaterial()) {
            case Material.NOTE_BLOCK -> OraxenBlocks.getNoteBlockMechanic(blockData);
            case Material.TRIPWIRE -> OraxenBlocks.getStringMechanic(blockData);
            default -> null;
        };
    }

    public static NoteBlockMechanic getNoteBlockMechanic(BlockData data) {
        if (!NoteBlockMechanicFactory.isEnabled()) {
            return null;
        }
        if (!(data instanceof NoteBlock)) {
            return null;
        }
        NoteBlock noteBlock = (NoteBlock)data;
        return NoteBlockMechanicFactory.getBlockMechanic(noteBlock.getInstrument().getType() * 25 + noteBlock.getNote().getId() + (noteBlock.isPowered() ? 400 : 0) - 26);
    }

    public static NoteBlockMechanic getNoteBlockMechanic(Block block) {
        if (!NoteBlockMechanicFactory.isEnabled()) {
            return null;
        }
        if (block.getType() != Material.NOTE_BLOCK) {
            return null;
        }
        NoteBlock noteblock = (NoteBlock)block.getBlockData();
        return NoteBlockMechanicFactory.getBlockMechanic(noteblock.getInstrument().getType() * 25 + noteblock.getNote().getId() + (noteblock.isPowered() ? 400 : 0) - 26);
    }

    public static NoteBlockMechanic getNoteBlockMechanic(String itemID) {
        NoteBlockMechanic noteBlockMechanic;
        if (!NoteBlockMechanicFactory.isEnabled()) {
            return null;
        }
        Mechanic mechanic = NoteBlockMechanicFactory.getInstance().getMechanic(itemID);
        return mechanic instanceof NoteBlockMechanic ? (noteBlockMechanic = (NoteBlockMechanic)mechanic) : null;
    }

    public static StringBlockMechanic getStringMechanic(BlockData blockData) {
        if (!StringBlockMechanicFactory.isEnabled()) {
            return null;
        }
        if (!(blockData instanceof Tripwire)) {
            return null;
        }
        Tripwire tripwire = (Tripwire)blockData;
        return StringBlockMechanicFactory.getBlockMechanic(StringBlockMechanicFactory.getCode(tripwire));
    }

    public static StringBlockMechanic getStringMechanic(Block block) {
        if (!StringBlockMechanicFactory.isEnabled()) {
            return null;
        }
        if (block.getType() == Material.TRIPWIRE) {
            Tripwire tripwire = (Tripwire)block.getBlockData();
            return StringBlockMechanicFactory.getBlockMechanic(StringBlockMechanicFactory.getCode(tripwire));
        }
        return null;
    }

    public static StringBlockMechanic getStringMechanic(String itemID) {
        StringBlockMechanic stringMechanic;
        if (!StringBlockMechanicFactory.isEnabled()) {
            return null;
        }
        Mechanic mechanic = StringBlockMechanicFactory.getInstance().getMechanic(itemID);
        return mechanic instanceof StringBlockMechanic ? (stringMechanic = (StringBlockMechanic)mechanic) : null;
    }

    public static BlockMechanic getBlockMechanic(Block block) {
        if (block.getType() == Material.MUSHROOM_STEM) {
            return BlockMechanicFactory.getBlockMechanic(BlockMechanic.getCode(block));
        }
        return null;
    }
}

